//  Created by Allen Ingling on Wed Mar 31 2004.
//  Copyright (c) 2004 New York University. All rights reserved.
//
//  main.m
//  ccanim
//
//


/*

	NOTES:
	
	To debug in command line mode add the command line arguments to the exectuable pane in Xcode and launch the application in the debugger from Xcode.  
	Remember to undo the command line setting  after testing !
	
*/ 

#import <Cocoa/Cocoa.h>
#include <stdio.h>						//for HIPS
#include <hipl_format.h>				//for HIPS
#include "ExternHIPS.h"					//for HIPS
#import "HipsHelpers.h"					//for command line structure


/*

HIPS viewer command line flags:
	
-displaynumber			int												A number 0 to n where n-1 is the number of displays connected to the computer.  Specifies onto which display the image is presented
-displayname			string		first, middle, last					A name designating which display to use.  mutex with displaynumber. 
-palindrome				boolean											Play palendromicly 
-loop					boolean											Play continously.  Optionally accepts a number of loops.  0 stands for infinity. 
-forward				boolean											Play forwared.  Default true.  Mutex with reverse.
-reverse				boolean											Play in reverse
-exit					boolean											Exit after the animation plays.  Otherwise leave the application open
-background				string		black, white, gray, mean, edgemean
-getkeys				int												Continue to collect keypress for the specified period of seconds beyond end of the animation  
-preview				boolean											Open the movie in the preview window.  NOT YET ENABLED
-fullscreen				boolean											Open the movie in a fullscreen window.  NOT YET ENABLED
*/ 


// NOTE: We call parseargs from within main to get command line settings for relay to the Cocoa object via the commandFlags global variable.  
//We do this here and not in the Cocoa object because argc and argv are available within main amd not within the Cocoa object and are needed for parseargs().
//Alternately we could try forwarding argc and argv into the Cocla object via globals, though NSApplicationMain would have its way with them first.

//NOTE:  It obeys command line flags only if you supply a file name.
HipsViewerCommandFlagsType  commandFlags;


int main(int argc, const char *argv[])
{
	//static  Flag_Format flagfmt[] = {LASTFLAG};
	static  Flag_Format flagfmt[] = 
	{
		//flag				mutex list						min parameters		    parameter list: type&default&name triplet, ... LASTPARAMETER
		{"moviefile",		{LASTFLAG},						1,						{ {PTBOOLEAN, "FALSE"},  {PTSTRING, "foofilename", "movie_file"}, LASTPARAMETER }},
		{"displaynumber",   {"displayname", LASTFLAG},		1,						{ {PTBOOLEAN, "FALSE"},  {PTINT,   "0", "display-number"}, LASTPARAMETER }},
		{"displayname",		{"displaynumber", LASTFLAG},	1,						{ {PTBOOLEAN, "FALSE"},  {PTSTRING,  "last", "display-name"}, LASTPARAMETER }},
		{"palindrome",		{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   LASTPARAMETER }},
		{"loop",			{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   {PTINT,   "0", "number-of-loops"}, LASTPARAMETER }},
		{"forward",			{"reverse", LASTFLAG},			0,						{ {PTBOOLEAN, "TRUE"},   LASTPARAMETER }},
		{"reverse",			{"forward", LASTFLAG},			0,						{ {PTBOOLEAN, "FALSE"},   LASTPARAMETER }},
		{"exit",			{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   LASTPARAMETER }},
		{"background",		{LASTFLAG},						1,						{ {PTBOOLEAN, "FALSE"},  {PTSTRING,  "edgemean", "color-name"}, LASTPARAMETER }},
		{"getkeys",			{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   {PTINT, "0", "gather-extraduration"}, LASTPARAMETER }},
		{"preview",			{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   LASTPARAMETER }},
		LASTFLAG
	};
	
	commandFlags.useCommandLine=FALSE;
//	printf("argc: %d\n", argc);
//	printf("argv[0]: %s\n", argv[0]);

	if(argc > 2){
		parseargs(
			argc, argv, flagfmt, 
			&commandFlags.useCommandLine,
			&commandFlags.fileName,
			&commandFlags.displayNumberPresent,
			&commandFlags.displayNumber,
			&commandFlags.displayNamePresent,
			&commandFlags.displayName,
			&commandFlags.palindromeFlag,
			&commandFlags.continuousFlag,
			&commandFlags.numberOfLoops,
			&commandFlags.forwardFlag,
			&commandFlags.reverseFlag,
			&commandFlags.terminateFlag,
			&commandFlags.backgroundPresent,
			&commandFlags.backgroundColorName,
			&commandFlags.getKeysFlag,
			&commandFlags.getkeysExtraDuration,
			&commandFlags.usePreviewWindowFlag //,
//			FFONE, &commandFlags.fileName
		);

		//commandFlags.useCommandLine=strcmp("<stdin>", commandFlags.fileName);
	}
    return NSApplicationMain(argc, argv);
}



/*
constants for specifying command line parameter hips  from the hips_parser.h header.

#define PTBOOLEAN   0
#define PTCHAR	    1
#define PTSTRING    2
#define PTINT	    3
#define PTDOUBLE    4
#define PTFILENAME  5
#define PTLIST      6
*/


